#define PIN            6
#define NUMPIXELS      48


#include <Adafruit_NeoPixel.h>
#include <Wire.h>

const uint16_t IRange = 1000;
const uint16_t Range1 = 200;//255
const uint16_t Range2 = 300;//511
const float Range3 = 800;//767

uint8_t const PWM_Pin = 2;//Pin for RC-Channel
uint32_t sensorValue = 0;
uint8_t red,green,blue;
uint32_t TSBegin; //Timestamp Begin
uint32_t tPulse; //Pulslänge



Adafruit_NeoPixel pixels = Adafruit_NeoPixel(NUMPIXELS, PIN, NEO_GRB + NEO_KHZ800);

void setup() {
  
  // Initialize Serial port
  Serial.begin(9600);
  #if defined(__AVR_ATmega32U4__)
    while(!Serial);
  #endif
  Serial.println("Setup started");
  attachInterrupt(0, PWMIRQ, CHANGE);
  pixels.begin();
  randomSeed(tPulse);
}

void loop() {
  
  // Read the light levels (ambient, red, green, blue)
    sensorValue =DiscriminatePWM();
    Serial.print("Value:");
    Serial.print(sensorValue);
    Serial.print(" ");
    
    if (sensorValue<Range1){
      //ramp up
          Serial.println("-");      
          for(int i=0;i<NUMPIXELS;i++){
            pixels.setPixelColor(i, pixels.Color(0,0,0)); 
          }
    }
    else{
      if (sensorValue<Range2){
        //Red comes
        red=uint8_t(sensorValue-Range1)*(256/(Range2-Range1));
          Serial.print("red:");
          Serial.println(red);
        for(int i=0;i<NUMPIXELS;i++){
          pixels.setPixelColor(i, pixels.Color(red,random(0,red/8),random(0,red/8))); 
        }
      }
      else{
        if (sensorValue<Range3){
          //red goes to orange
          green=uint8_t((sensorValue-Range2)*(70/(Range3-Range2)));
          Serial.print("green:");
          Serial.println(green);
          for(int i=0;i<NUMPIXELS;i++){
            pixels.setPixelColor(i, pixels.Color(255,green,random(0,green/2))); 
          }
        }
        else{
          if (sensorValue<IRange){
            //orange goes to blue
            //green=70-uint8_t((sensorValue-Range3+1)*(70/(Range3-Range2)));
            //blue=uint8_t((sensorValue-Range3)*(256/(Range3-Range2)));
            green=70+uint8_t((sensorValue-Range3+1)*(150/(IRange-Range3)));
            blue=uint8_t((sensorValue-Range3)*(256/(IRange-Range3)));
            Serial.print("green/blue:");
            Serial.print(green);
            Serial.print(";");
            Serial.println(blue);
            for(int i=0;i<NUMPIXELS;i++){
              pixels.setPixelColor(i, pixels.Color(random(128,255),green,blue));
            }
          }
           else{
             //Range.limit
             Serial.println("eRange");
             for(int i=0;i<NUMPIXELS;i++){
               pixels.setPixelColor(i, 255,255,255);
             }
          } 
        }//endRange 3/4
      }
    }
    pixels.show(); // This sends the updated pixel color to the hardware.
    

  // Wait 1 second before next reading
  delay(50);
}

void PWMIRQ()
{
  if (digitalRead(PWM_Pin)==HIGH){
    TSBegin=micros();
  }
  else{
    tPulse=micros()-TSBegin;
  }
}

uint32_t DiscriminatePWM(){

  uint32_t Pulse;
   Pulse=tPulse;
   Pulse=(Pulse-1000);
   return(Pulse);
}

